RDM_TechFieldCosts = {8000,5500,3500,5500,3500,5500,10000,15000,10000,10000,15000,15000,22500,22500,33000,33000,45000,45000,45000,65000,65000,90000}
RDM_TechId = {
	'RDM_AutomatedSystems', 
	'RDM_ModularEngineering', 
	'RDM_AdvancedStorage', 
	'RDM_AdvancedRefining', 
	'RDM_MartianThermalReactor', 
	'RDM_MartianGeothermalGenerator', 
	'RDM_QuantumComputing', 
	'RDM_SpecializedDome',
}

-- Format : TechId = { { ModClassname, Mod Name }, [...]}
RDM_TechModRequired = {
	RDM_AutomatedSystems = {
		{'RDM_ModAutomatedExtractors', 'Automated Extractors'}, 
		{'RDM_ModAutomatedFactories', 'Automated Factories'},
	},
	RDM_ModularEngineering = {
		{'RDM_ModModularApart', 'Modular Apartments'}, 
		{'RDM_ModSkylineOne', 'Arcology Skyline'},
	},
	RDM_AdvancedStorage = {
		{'RDM_ModLargeUniversalDepot','Large Universal Depot'},
	},
	RDM_AdvancedRefining = {
		{'RDM_ModAdvancedFuelRefinery', 'Advanced Fuel Refinery'},
		{'RDM_ModFuelFactorySpire', 'Fuel Factory Spire'},
	},
	RDM_MartianThermalReactor = {
		{'RDM_ModFueledReactor', 'Fueled Reactor'}
	},
	RDM_MartianGeothermalGenerator = {
		{'RDM_ModGeoThermalPower', 'GeoThermalPower'},
	},
	RDM_QuantumComputing = {
		{'RDM_ModSuperComputer','Super Computer'},
	},
	RDM_SpecializedDome = {
		{'RDM_ModAgridome','Agridome'},
	},
}
-- <RDM_GetTechMods('tech_id')>
function TFormat.RDM_GetTechMods(context_obj, tech_id) 
	local def = RDM_TechModRequired[tech_id]
	local text = T(1337002, "<em>Affected Mods</em>: ")
	
	for _, req_mod in ipairs(def) do
		if RDM_CheckModLoaded(req_mod[1]) then
			text = text .. T('[<green>' .. req_mod[2] .. '</green>] ')
		else
			text = text .. T('[<red>' .. req_mod[2] .. '</red>] ')
		end
	end
	
	return text
end

-- Init SILVATECH & les nouvelles techs pour les Sauvegardes
-- Fonctionne aussi en cas d'ajout de nouvelles techs
function OnMsg.RDM_SavegameFixups()
	local UICity = UICity
	local field = "RDM_SilvaTech"
	local costs = RDM_TechFieldCosts
	
	if not UICity.tech_field[field] then
		UICity.tech_field[field] = {}
		ModLog("[SILVA] [Fix] SILVATECH Techfield added.")
	end

	local count = 0
	for _, tech_id in ipairs (RDM_TechId) do
		local tech = Presets.TechPreset[field][tech_id]
		local tech_pos = tech.position.from
		
		if not UICity.tech_status[tech_id] then
			UICity.tech_status[tech_id] = {
				cost = costs[tech_pos],
				field = field,
				points = 0,
			}
			table.insert(UICity.tech_field[field], tech_pos, tech_id)
			UICity:SetTechDiscovered(tech_id)
			
			count = count + 1
		elseif UICity.tech_status[tech_id].cost ~= costs[tech_pos] then
			UICity.tech_status[tech_id].cost = costs[tech_pos]
			ModLog("[SILVA] [Fix] ".. tech_id .." cost updated.")
		end
	end
	
	if count > 0 then
		ModLog("[SILVA] [Fix] ".. count .." New technologies added.")
	end
end

function RDM_Core:Load_TechFieldPresets()
	-- TechField
	local techfield_id = "RDM_SilvaTech"
	local props = {
			SortKey = 6500,
			costs = RDM_TechFieldCosts,
			description = T(186834091186,"Special techfield to unlock various buildings and upgrades created by Silva if you have installed his mods."),
			display_name = T(956272398181,"SILVATECH"),
			group = "Default",
			id = techfield_id,
		}
		
	if not TechFields[techfield_id] then
		PlaceObj('TechFieldPreset', props )
	else
		-- Keep update
		TechFields[techfield_id].costs = props.costs
	end
	
	if TechFields[techfield_id] then 
		ModLog("[SILVA] TechfieldPresets loaded.")
	else
		ModLog("[SILVA][Error] TechfieldPresets doesn't loaded.")
	end
end

function RDM_Core:Load_TechPresets()
	local path = CurrentModPath .. "UI/Icons/Research/"
	local group = "RDM_SilvaTech"

	-- TechPreset
	PlaceObj('TechPreset', {
		SortKey = 10,
		comment = "(1)",
		description = T(523997265081,"Unlocks automated factories and extractors. Don't require workers or Domes.\n<RDM_GetTechMods('RDM_AutomatedSystems')>"),
		display_name = T(138328193004, "Automated Systems"),
		group = group,
		icon = path .. "RDM_AutomatedSystems.png",
		id = "RDM_AutomatedSystems",
		position = range(1, 1),
		PlaceObj('Effect_Code', {
			OnInitEffect = function (self, city, parent)
			city:SetTechDiscovered('RDM_AutomatedSystems')
		end,}),
	})
	
	PlaceObj('TechPreset', {
		SortKey = 20,
		comment = "(2)",
		description = T(848023317785,"Unlocks modular buildings.\n<RDM_GetTechMods('RDM_ModularEngineering')>"),
		display_name = T(686386937002,"Modular Engineering"),
		group = group,
		icon = path .. "RDM_ModularEngineering.png",
		id = "RDM_ModularEngineering",
		position = range(2, 2),
		PlaceObj('Effect_Code', {
			OnInitEffect = function (self, city, parent)
			city:SetTechDiscovered('RDM_ModularEngineering')
		end,}),
	})
	
	PlaceObj('TechPreset', {
		SortKey = 30,
		comment = "(3)",
		description = T(921065340334,"Unlocks larger depots.\n<RDM_GetTechMods('RDM_AdvancedStorage')>"),
		display_name = T(639562212658,"Advanced Storage"),
		group = group,
		icon = path .. "RDM_AdvancedStorage.png",
		id = "RDM_AdvancedStorage",
		position = range(3, 3),
		PlaceObj('Effect_Code', {
			OnInitEffect = function (self, city, parent)
			city:SetTechDiscovered('RDM_AdvancedStorage')
		end, }),
	})
	
	PlaceObj('TechPreset', {
		SortKey = 40,
		comment = "(4)",
		description = T(606375500326,"Unlocks better fuel refineries and various factories.\n<RDM_GetTechMods('RDM_AdvancedRefining')>"),
		display_name = T(615043022016,"Advanced Refining"),
		group = group,
		icon = path .. "RDM_AdvancedRefining.png",
		id = "RDM_AdvancedRefining",
		position = range(4, 4),
		PlaceObj('Effect_Code', {
			OnInitEffect = function (self, city, parent)
			city:SetTechDiscovered('RDM_AdvancedRefining')
		end,}),
	})
	
	PlaceObj('TechPreset', {
		SortKey = 50,
		comment = "(5)",
		description = T(126239727200,"Unlocks new powerful thermal reactors to produce energy or heat.\n<RDM_GetTechMods('RDM_MartianThermalReactor')>"),
		display_name = T(414010983367,"Martian Thermal Reactor"),
		group = group,
		icon = path .. "RDM_MartianThermalReactorg.png",
		id = "RDM_MartianThermalReactor",
		position = range(5, 5),
		PlaceObj('Effect_Code', {
			OnInitEffect = function (self, city, parent)
			city:SetTechDiscovered('RDM_MartianThermalReactor')
		end,}),
	})
	
	PlaceObj('TechPreset', {
		SortKey = 60,
		comment = "(6)",
		description = T(819357277200,"Unlocks Martian geothermal technologies to produce energy or heat.\n<RDM_GetTechMods('RDM_MartianGeothermalGenerator')>"),
		display_name = T(565324395178,"Martian Geothermal Generator"),
		group = group,
		icon = path .. "RDM_MartianGeothermalGenerator.png",
		id = "RDM_MartianGeothermalGenerator",
		position = range(6, 6),
		PlaceObj('Effect_Code', {
			OnInitEffect = function (self, city, parent)
			city:SetTechDiscovered('RDM_MartianGeothermalGenerator')
		end,}),
	})
	
	PlaceObj('TechPreset', {
		SortKey = 70,
		comment = "(7)",
		description = T(783807992884,"Unlocks powerful buildings using the Quantum technology.\n<RDM_GetTechMods('RDM_QuantumComputing')>"),
		display_name = T(805484400896,"Quantum Computing"),
		group = group,
		icon = path .. "RDM_QuantumComputing.png",
		id = "RDM_QuantumComputing",
		position = range(7, 7),
		PlaceObj('Effect_Code', {
			OnInitEffect = function (self, city, parent)
			city:SetTechDiscovered('RDM_QuantumComputing')
		end,}),
	})
	
	PlaceObj('TechPreset', {
		SortKey = 80,
		comment = "(8)",
		description = T(442091877399,"Unlocks specialized dome buildings.\n<RDM_GetTechMods('RDM_SpecializedDome')>"),
		display_name = T(970578298377,"Specialized Dome"),
		group = group,
		icon = path .. "RDM_SpecializedDome.png",
		id = "RDM_SpecializedDome",
		position = range(8, 8),
		PlaceObj('Effect_Code', {
			OnInitEffect = function (self, city, parent)
			city:SetTechDiscovered('RDM_SpecializedDome')
		end, }),
	})
	
	ModLog("[SILVA] TechPresets loaded.")
end

